s                                                            tsp3220     Thurlby-Thandar TSP3220 series PSU.               Thurlby-Thandar TSP3220 series power supplies

This instrument module provides GPIB support for
the TSP3220 series power supplies. Instruments in
this range meet the requirements of IEEE 488.2
standard. The module will be updated from time to
time as new instruments become available in the
range.

Instruments supported are:

TSP3222         Dual 32 volt, 2 amp, Quad mode

The module contains the following functions:

1. Initialise.

2. Configuration
        1. Set Mode
        2. Set Output
        3. Master Output control
        4. Status Reporting

3. Measurement and Status.
        1. Read Output
        2. Read Status

4.Local Storage.
        1. Store
        2. Recall

5. Close    J                  Configuration Functions

These functions perform the complete set up of the
TSP322x power supply. The parameters are sent to
the instrument but the status is not checked so no
instrument errors will be reported. Status may be
read at any time with the read status function.
Available functions are listed below.

Set mode: Set the instrument to the required mode.

Set Voltage Set Voltage for each output.

Set Current Set current for each output.

Set OVP     Set OVP for each output.

Set Output status   Set output status for each
                    output.

Set damping Set readback meter damping for each
            output.

Master output control: Set master output switch on
or off.

Status reporting: Specify the way in which status
is reported and Service Request is generated as
defined in the IEEE 488.2 standard.
    L                Measurement and Status

These functions allow the voltage and current to
be read on each output and the status registers to
be interrogated. Available functions are as
follows.

Read output: Reads the current and voltage from
the specified output.

Read status: Returns the byte value in the
selected status register.
                      Local Storage

These functions allow the instrument set up to be
stored or recalled from local non-volatile memory.

Store saves the set up to a store specified by the
user.

Recall gets a set up from a store specified by the
user and install it in the TSP322x.
    -                 Miscelaneous

These functions allow commands to be sent and
responses to be received which are not covered by
other panels in the instrument driver.

Any commands may be sent as a string of bytes.

Responses are received as a string of bytes for
later interrogation by the user program.        Panel name:     Initialise

Description:

 Initialises the TSP322x in the following way

        - opens the instrument and sets the GPIB
        address to the specified value.

        - sends device clear and clear status
        commands.

        - queries the instrument to determine the
        type/model number.

        - optionally sets the instrument to its
        default state.

        - optionally performs a self test on the
        instrument.
    U    Control name:   GPIB Address

Description:    This control specifies the
                address used to communicate with
                the TSP322x power supply. It must
                correspond with the value set up
                at the instrument front panel.

Variable type:  Integer

Valid range:    0 to 30

Default value:  11

    
     Control Name:  Instrument ID

 Description:   Returns an Instrument ID that is
                used in all subsequent function
                calls to select the instrument at
                the Address specified.

                If more than one instrument of the
                same type is used, this value will
                be used to differentiate between
                them. The first instrument
                initialized will be assigned an
                Instrument ID of 1.

 Variable Type: Integer    `    Control name:   Set Defaults

Description:    When set to Yes the parameters
                in the instrument will be set to
                their default values. If set to No
                the instrument settings will not
                be changed.

Variable type:  Integer

Valid range:    No = 0 , Yes = Any non-zero value

Default value:  Yes         Control name:   Perform Self Test

Description:    Specifies if a self test should
                be performed or not. If the test
                is performed the returned value
                will be in the global variable
                TSP3220_err. A value of zero
                indicates that the test passed.
                See the Error control for a list
                of possible returned values.

Variable type:  Integer

Valid range:    No = 0 , Yes = Any non-zero value

Default value:  No
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   GPIB Address out of range
       -2   ID Query out of range
       -3   Reset Device out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      239   Error configuring time out
      240   Instrument timed out     - |           GPIB Address                      
n -          Instrument ID                                 Set Defaults                       2          Perform Self Test                           Error                                                                       (                                            11    	           Yes 1 No 0    Yes 1 No 0    	            (Instrument driver version 2.0 Apr. 1995    Copyright (c) TTi Ltd.       Panel name:     Set Mode

Description:

 Set the instrument to the required mode. Modes
 available are instrument dependant. Tracking is
 possible only between outputs which are
 internally isolated. The number of legal modes is
 instrument dependent.

 TSP3222 Modes:

  Mode No.            Description
 ------------   ------------------------------
     0          Outputs 1 and 2 isolated.
                Outputs 1 and 2 may be set to
                tracking (Tracking A = 3).

      1         Outputs 1 and 2 series connected.
                Tracking not possible.

      2         Outputs 1 and 2 parallel
                connected.
                Tracking not possible.
         Control name:   Mode

Description:    Selects The required mode.

Variable type:  Integer

Valid range:    Instrument dependent
                (maximum is 0 to 13)

Default value:  0 (all outputs isolated)    ,    Control name:   Trip Mode

Description:    Specifies the action to be taken
                when any output trips for any
                reason - ovp or temperature. When
                set to All then the complete
                instrument is shut down - the
                Master On/Off switch is set to
                Off. When set to Single then only
                the output which tripped is shut
                down - Output Status is set Off.

Variable type:  Integer

Valid range:   0 = All
               1 = Single

Default value:  All
         Control name:   Tracking A

Description:    Selects one of two possible
                tracking specifications.

Variable type:  Integer

Valid range:    Instrument dependent - see manual

Default value:  0 - no tracking

    _    Control name:   Tracking B

Description:    Selects one of two possible
                tracking specifications. This
                value should be set to zero for
                all except quadruple output
                instruments.

Variable type:  Integer

Valid range:    Instrument dependent - see manual

Default value:  0 - no tracking

    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Mode value out of range
       -3   Tracking A value out of range
       -4   Tracking B valur out of range
       -5   Trip mode value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out     -          Mode                               -2          Trip Mode                         * m          Tracking A                                   Tracking B                        z             Instrument ID                     !          Error                                         Isolated 0 Series 1 Parallel 2    Single 1 All 0               off 0 1 track 2 3               off 0    1    	                Panel name:     Set Voltage

Description:    sets the voltage on the selected
                output.

 The values which are legal depend on the
 instrument type and the Mode and Tracking
 specification.
    )    Control name:   Output Number

Description:    Indicates the output number to
                which the commands will be sent.

Variable type:  integer

Valid range:    min = 1 , max = number of outputs
                available for the particular
                instrument.

Default value   1
         Control name:   Voltage

Description:    The voltage value to which the
                specified output will be set. The
                value is expressed in Volts.

Variable type:  real

Valid range:    instrument dependent

    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    Z     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output number out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    &Q M           Output Number                     ' M         Voltage                           (p             Instrument ID                     *          Error                                         1 1 2 2        1    	                Panel name:     Set Current

Description:    sets the current limit on the
                selected output.

 The values which are legal depend on the
 instrument type and the Mode and Tracking
 specification.
    )    Control name:   Output Number

Description:    Indicates the output number to
                which the commands will be sent.

Variable type:  integer

Valid range:    min = 1 , max = number of outputs
                available for the particular
                instrument.

Default value   1
         Control name:   Current

Description:    The current limit value to which
                the specified output will be set.
                The value is expressed in Amps.

Variable type:  real

Valid range:    instrument dependent


    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    Z     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output number out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    . M           Output Number                     /? M         Current                           03             Instrument ID                     2          Error                                         1 1 2 2        1    	                Panel name:     Set OVP

Description:    sets the OVP on the selected
                output.

 The values which are legal depend on the
 instrument type and the Mode and Tracking
 specification.
    )    Control name:   Output Number

Description:    Indicates the output number to
                which the commands will be sent.

Variable type:  integer

Valid range:    min = 1 , max = number of outputs
                available for the particular
                instrument.

Default value   1
        Control name:   OVP

Description:    The over voltage protection value
                to which the specified output will
                be set. The value is expressed in
                Volts.

Variable type:  real

Valid range:    instrument dependent


    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    Z     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output number out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    5 M           Output Number                     6 M         OVP                               7             Instrument ID                     :_          Error                                         1 1 2 2        1    	                Panel name:     Set output status

Description:    Set output status, specifies
                whether the output status of the
                specified output is on or off.
    )    Control name:   Output Number

Description:    Indicates the output number to
                which the commands will be sent.

Variable type:  integer

Valid range:    min = 1 , max = number of outputs
                available for the particular
                instrument.

Default value   1
         Control name:   Output Status

Description:    Specifies the status of the
                specified output.

Variable type:  integer

Valid range:    0 = Off
                1 = On

default value:  Off

    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output number out of range
       -3   Status value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    ={ M           Output Number                     > N-          Output Status                     ?             Instrument ID                     A          Error                                         1 1 2 2    On 1 Off 0    1    	                Panel name:     Set Damping

Description:    Specifies the reading meter
                damping for the voltage and
                current of the specified output.
    )    Control name:   Output Number

Description:    Indicates the output number to
                which the commands will be sent.

Variable type:  integer

Valid range:    min = 1 , max = number of outputs
                available for the particular
                instrument.

Default value   1
         Control name:   Meter Damping

Description:    Specifies the dampimg applied to
                the readback metering of the
                selected output.

Variable type:  integer

Valid range:    0 = off
                1 = On

default value:  Off

    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output number out of range
       -3   Danmping value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    E$ M           Output Number                     FU N/          Meter Damping                     G\             Instrument ID                     I          Error                                         1 1 2 2    On 1 Off 0    1    	            \    Panel name:     Master Output Control

Description:

 Set master output switch on or off.
        Control name:   Master Output

Description:    Used to set the master output
                switch On or Off. When On The
                voltage on all outputs, which
                have their individual Output
                Status switches set to On, will
                appear at the output terminals of
                the instrument.

Variable type:  integer

Valid range:    0 = Off
                1 = On

default value:  Off
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    Z     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output status out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    L ]           Master Output                     Nt             Instrument ID                     P          Error                              On 1 Off 0    1    	           ,    Panel name:     Status Reporting

Description:

 Specify the way in which status is reported and
 Service Request is generated as defined in the
 IEEE 488.2 standard.

 The function provides access to the four status
 enable registers in the TSP322x power supply,
 these are:

 Service Request Enable Register

        - Specifies which bits, when set, in the
        Status Byte register will generate a
        Service Request.

 Standard Event Enable Register

        - Specifies which bits, when set, in the
        Standard Event Status register will set
        the ESB bit in the Status Byte Register.

 Limit Event Register

        - Specifies which bits, when set, in the
        Limit Event Status register will set the
        LIM bit in the Status Byte Register.

 Parallel Poll Enable Register

        - Specifies which bits, when set, in the
        Status Byte register will be used to form
        the ist local message

 See the IEEE 488.2 Standard and the instrument
 instruction book for a full description of status
 reporting capabilities.


         Control name:   Set Status Enable

Description:    Used to select which enable
                register will receive the byte
                value.

Variable type:  integer

Valid range:    min = 0 , max = 3

Default value   0 (SRQ Enable)

         Control name:   Value

Description:    A byte value which will be written
                to the selected enable register.

Variable type:  integer

Valid range:    0 to 255

Default value:  0
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Set status enable out of range
       -3   Byte value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    W( ]           Set Status Enable                 X$ ]          Value                             X             Instrument ID                     [O          Error                                         :SRQ enable 0 Event Enable 1 Limit Enable 2 Parallel Pol 3    0    1    	            c    Panel name:     Read Output Voltage

Description:

 Returns the voltage from the selected output.    )    Control name:   Output Number

Description:    Indicates the output number from
                which the values will be read.

Variable type:  integer

Valid range:    min = 1 , max = number of outputs
                available for the particular
                instrument.

Default value   1
         Control Name:   Output voltage

Description:    Voltage being output from the
                power supply.

Control Type:   Real.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output number out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out    ^w ]           Output Number                     _ ^         Output Voltage                    `4             Instrument ID                     b          Error                                         1 1 2 2    	           1    	            c    Panel name:     Read Output Currant

Description:

 Returns the current from the selected output.    )    Control name:   Output Number

Description:    Indicates the output number from
                which the values will be read.

Variable type:  integer

Valid range:    min = 1 , max = number of outputs
                available for the particular
                instrument.

Default value   1
         Control Name:   Output current

Description:    Current being output by the power
                supply.

Control Type:   Real    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output number out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out    e ]           Output Number                     f _         Output Current                    gM             Instrument ID                     i          Error                                         1 1 2 2    	           1    	            x    Panel name:     Read Status

Description:    Returns the byte value from the
                selected status register.         Control name:   Read Status

Description:    Used to select which status
                register to read

Variable type:  integer

Valid range:    min = 0 , max = 6

Default value   0 (Status Byte)

         Control Name:   Value

Description:    Retuened byte value of the
                selected register.

Control Type:   integer

Valid range:    0 to 255 - register value
                -1 - an error was encountered.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Status register number out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out    l =           Read Status                       m =+          Value                             nt             Instrument ID                     p          Error                                         bStatus byte 0 Std Event 1 Limit Event 2 SRQ enable 3 Event Enable 4 Limit Enable 5 Parallel Pol 6    	            1    	                Panel name:     Store

Description:    Saves the complete state of the
                TSP322x to local non-volatile
                memory.         Control name:   Store number

Description:    Select the number of the store to
                receive the instrument set up.

Variable type:  integer

Valid range:    1 to 25
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Set status enable out of range
       -3   Byte value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    ta ]           Store number                      u             Instrument ID                     w|          Error                                  1    	            w    Panel name:     Recall

Description:    Recalls an instrument set up from
                a previous store operation.         Control name:   Store number

Description:    Select the number of the store
                from which to recall the
                instrument set up.

Variable type:  integer

Valid range:    1 to 25
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Set status enable out of range
       -3   Byte value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    z9 ]           Store number                      {             Instrument ID                     }n          Error                                  1    	                Panel name:     Send command string

Description:    Sends a string of bytes to the
                tsp322x from a string variable.         Control name:   Command String

Description:    This control specifies data to be
                sent to the TSP322x. The absolute
                maximum length allowed is 2000
                bytes.

Variable type:  String


    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Set status enable out of range
       -3   Byte value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    9 =          Command String                    '             Instrument ID                               Error                                  1    	                Panel name:     Get response string

Description:    Reads a response from the tsp322x
                into a string variable.    
    Control name:   Response Stirng

Description:    This control specifies a string
                variable to receive the response
                from the TSP322x. The string must
                be long enough to receive the
                response to avoid overflow. To aid
                in checking this the number of
                bytes put into the string is
                returned from the function. The
                absolute maximum length allowed is
                2000 bytes.

Variable type:  String
         Control name:   Number of Bytes

Description:    This value is the number of bytes
                returned by the TSP322x and
                placed in the string.

Variable type:  Integer    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Status register number out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out    M =          Response String                   _ =9          Number of Bytes                   &             Instrument ID                               Error                              	            	            1    	                Panel name:     Send block from file

Description:    Sends a binary block to the
                tsp322x from a disc file.

Note            This operation is usefull for
                Learn and Store blocks.         Control name:   File name

Description:    This control specifies file name
                from which the binary block will
                be sent to the TSP322x.

Variable type:  String - max length 50 characters


    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    e     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      228   Error writing to instrument from file
      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out     M          File name                                      Instrument ID                     8          Error                                  1    	                Panel name:     Get block to file

Description:    Gets a binary block from the
                tsp322x and writes it to a disc
                file.

Note            This operation is usefull for
                Learn and Store blocks.         Control name:   File name

Description:    This control specifies file name
                to which the binary block will be
                written when read from the
                TSP322x.

Variable type:  String - max length 50 characters


    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    e     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      229   Error reading from instrument to file
      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    O M          File name                         P             Instrument ID                               Error                                  1    	                Panel name:     Close

Description:    Takes the instrument off-line.
                The  instrument must  be
                reinitialized to use it again.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   GPIB Address out of range
       -2   ID Query out of range
       -3   Reset Device out of range

      221   Unable to close instrument
      223   Instrument identification query failed
      232   Instrument not initialized    x             Instrument ID                               Error                              1    	                  
8  z     K.    init                                     l  #     K.    set_mode                                 %{  ,2     K.    set_volts                                -2  3     K.    set_current                              4  ;     K.    set_ovp                                  <  Cj     K.    set_op_stat                              Dt  KF     K.    set_damping                              LP  R6     K.    master_op                                R  \     K.    set_status                               ^  d      K.    read_op_volts                            e(  k9     K.    read_op_current                          lA  ri     K.    read_status                              s  y     K.    store                                    y  ~     K.    recall                                          K.    send_cmd                                        K.    get_response                                    K.    send_from_file                           Y       K.    get_to_file                                k     K.    close                                                                       DInitialise                          ?Configure                            DSet Mode                             DSet Voltage                          DSet Current                          DSet OVP                              DSet Output Status                    DSet Damping                          DMaster Output Control                DStatus Reporting                    Measurement and Status               DRead Output Voltage                  DRead Output Current                  DRead Status                         Local Storage                        DStore                                DRecall                              	Miscellaneous                        DSend Command String                  DGet Response String                  DSend Block From File                 DGet Block to File                    DClose                           